// CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D 
// Program.cs
// AvP[ṼC
// CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D  CBDX-D 

using System;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Threading;

public static class Program
{
    // O[oϐ̑ (statictB[h)
    private static string ComPort = "COM1"; // ftHg
    private static bool f_SigTerm = false;
    private static long g_lBalance = 0;

    // MVT֘ÃXe[^Xϐ
    private static ushort MVT_Status;
    private static ushort MVT_Error;
    private static byte[] MVT_Result = new byte[128];
    private static byte[] MVT_SettlementStatus = new byte[6];
    private static int MVT_BrandCount = 0;
    private static byte[,] MVT_BrandStatus = new byte[8, 13];
    private static ushort MVT_RcvFlag = 0;

    private static SerialCommunicator? s_comm;

    // C̃Gg[|Cg
    public static void Main(string[] args)
    {
        if (args.Length >= 1)
        {
            ComPort = args[0];
        }

        Logger.Initialize();
        Logger.LogEx("CardInitvON");
        Logger.Log(0x0001, "CardInitvON");

        // |[gEI[v
        s_comm = new SerialCommunicator();
        if (!s_comm.Open(ComPort))
        {
            Console.WriteLine("VA|[g̃I[vɎs܂BI܂B");
            Logger.LogEx("vIȃG[: VA|[g̃I[vɎs܂B");
            return;
        }

        // EX^oCM
        InitStandby();

        uint iStartRetryCnt = 0;
        do
        {
            if (iStartRetryCnt != 0)
            {
                Thread.Sleep(5 * 1000);
            }
            SendStandby();

            if (iStartRetryCnt == 0)
            {
                Logger.Log(0x0002, "CardInitJn");
            }
            else
            {
                Logger.Log(0x0002, $"CardInitĊJn{iStartRetryCnt}");
            }
            iStartRetryCnt++;

        } while (MVT_AllRequest() == -2); // X^oCKvȊԂ̓gC

        Thread.Sleep(100);

        MVT_RcvFlag &= unchecked((ushort)~JVMAConstants.MVT_RCV_1DH);

        // ʃf[^M
        MVT_Kobetu_Send();

        // uh킹
        MTV_Brand_Awase();

        // C[v (ԑJ)
        int phase = 0;
        int subphase = 0;
        int phase_bak = -1;
        int subphase_bak = -1;
        
        do
        {
            DispPhase(phase, subphase, ref phase_bak, ref subphase_bak);

            // ͗v (ωmF)
            MVT_ChangedRequest();

            // ԑJ
            switch (phase)
            {
                case 0: // ̔Jn
                    MVT_Ctrl_Send(0x01);
                    Logger.Log(0x0000, "̔Jn");
                    phase = 10;
                    subphase = 0;
                    break;

                case 10: // ҋ@
                    switch (subphase)
                    {
                        case 0:
                            Phase10_0(ref phase, ref subphase);
                            break;
                    }
                    break;
            }
            Thread.Sleep(70);
        } while (!f_SigTerm);

        Logger.Log(0x0000, "CardInitI");
        s_comm.Close();
    }

    //-----------------------------------------------------------
    // Phase10_0 : ҋ@ԁE̔Ԃ̊mF
    //-----------------------------------------------------------
    private static void Phase10_0(ref int pphase, ref int psubphase)
    {
        if ((MVT_RcvFlag & JVMAConstants.MVT_RCV_18H) != 0) // \˗f[^
        {
            MVT_RcvFlag &= unchecked((ushort)~JVMAConstants.MVT_RCV_18H);
            // cz\
            try
            {
                // 64bitłnĕʃvZXNWIȕ@
                ProcessStartInfo startInfo = new ProcessStartInfo("Balance.exe")
                {
                    Arguments = $"2 {g_lBalance}",
                    UseShellExecute = true // ʏ̎s@
                };
                Process.Start(startInfo);
            }
            catch (Exception ex)
            {
                Console.WriteLine($"Balance.exe̋NɎs: {ex.Message}");
            }
        }
        else if ((MVT_RcvFlag & JVMAConstants.MVT_RCV_1DH) != 0) // uhԃf[^
        {
            // uh킹
            MVT_BrandSet_Send();
            MVT_RcvFlag &= unchecked((ushort)~JVMAConstants.MVT_RCV_1DH);

            // ̃Tvł͂ŏI܂B
            // f_SigTerm = true;
        }
        // ̃tȌ...
    }

    //-----------------------------------------------------------
    // tF[Yʕ\
    //-----------------------------------------------------------
    private static void DispPhase(int phase, int subphase, ref int pphase_bak, ref int psubphase_bak)
    {
        if ((psubphase_bak != subphase) || (phase != pphase_bak))
        {
            Logger.LogEx($"**** [{phase,4},{subphase,4}]   {DateTime.Now:yyyy/MM/dd HH:mm:ss} ****");
            pphase_bak = phase;
            psubphase_bak = subphase;
        }
    }

    //-----------------------------------------------------------
    // EX^oCM (CBDX-D֘A)
    //-----------------------------------------------------------
    private static void InitStandby()
    {
        CheckCBDX();
        CBDX_Ctrl_Send();
        CBDX_Ctrl_Send();
        Thread.Sleep(5000);
    }

    private static void SendStandby()
    {
        while (MVT_Standby() == -1)
        {
            Logger.LogEx($"---- {DateTime.Now:yyyy/MM/dd HH:mm:ss} ------------------");
            Logger.LogEx("connected and fail in XXXXX... reconnect it five seconds later.");
            if (f_SigTerm) break;
            Thread.Sleep(5000);
        }
        Thread.Sleep(100);
    }

    //-----------------------------------------------------------
    // MVT/JVMA ʐM֐
    //-----------------------------------------------------------

    private static int MVT_Standby() => JVMA_Standby(JVMAConstants.JVMA_MVT_TERM);
    private static int MVT_AllRequest() => JVMA_AllRequest(JVMAConstants.JVMA_MVT_TERM);
    private static int MVT_ChangedRequest() => JVMA_ChangedRequest(JVMAConstants.JVMA_MVT_TERM);

    private static int JVMA_Standby(byte terminal)
    {
        byte[] txData = { (byte)(JVMAConstants.CMD_STBY | terminal), (byte)~(JVMAConstants.CMD_STBY | terminal) };
        
        Logger.LogEx($"---- {DateTime.Now:yyyy/MM/dd HH:mm:ss} ------------------");
        Logger.LogEx($"[->S:{txData[0]:X2}] [{txData[1]:X2}]");
        Logger.LogEx("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");

        byte[] rxData = new byte[JVMAConstants.PACKET_BUFFER_SIZE];
        int result = s_comm!.MvtTxRx(txData, rxData);
        
        if (result != 1 || rxData[0] != JVMAConstants.MVT_ACK_ACK1)
        {
            return -1; // communication error
        }
        return 0;
    }
    
    private static int JVMA_AllRequest(byte terminal)
    {
        byte[] txData = { (byte)(JVMAConstants.CMD_AREQ | terminal), (byte)~(JVMAConstants.CMD_AREQ | terminal) };
        byte[] rxData = new byte[JVMAConstants.PACKET_BUFFER_SIZE];

        int result = s_comm!.MvtTxRx(txData, rxData);

        if (result > 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK1)
        {
            MVTAnalyze(rxData[0], (byte)(result - 1), rxData, 2);
        }
        else if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK4)
        {
            return -2; // X^oCKv
        }
        else
        {
            // Re-request
            txData = new byte[] { (byte)(JVMAConstants.CMD_REREQ | terminal), (byte)~(JVMAConstants.CMD_REREQ | terminal) };
            result = s_comm!.MvtTxRx(txData, rxData);
            if (result > 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK3)
            {
                MVTAnalyze(rxData[0], (byte)(result - 1), rxData, 2);
            }
            else
            {
                return -1; // communication error
            }
        }
        return 0;
    }

    private static int JVMA_ChangedRequest(byte terminal)
    {
        byte[] txData = { (byte)(JVMAConstants.CMD_CREQ | terminal), (byte)~(JVMAConstants.CMD_CREQ | terminal) };
        byte[] rxData = new byte[JVMAConstants.PACKET_BUFFER_SIZE];

        int result = s_comm!.MvtTxRx(txData, rxData);

        if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK1)
            return 0; // ωȂ
        if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK4)
            return -1; // X^oCKv
        if (result > 1 && (rxData[0] == JVMAConstants.MVT_ACK_ACK2 || rxData[0] == JVMAConstants.MVT_ACK_ACK3))
        {
            MVTAnalyze(rxData[0], (byte)(result - 1), rxData, 2);
            return 1;
        }
        
        // Re-request
        txData = new byte[] { (byte)(JVMAConstants.CMD_REREQ | terminal), (byte)~(JVMAConstants.CMD_REREQ | terminal) };
        result = s_comm!.MvtTxRx(txData, rxData);
        if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK1)
            return 0; // ωȂ
        if (result > 1 && (rxData[0] == JVMAConstants.MVT_ACK_ACK2 || rxData[0] == JVMAConstants.MVT_ACK_ACK3))
        {
            MVTAnalyze(rxData[0], (byte)(result - 1), rxData, 2);
            return 1;
        }

        return -1; // communication error
    }
    
    private static int JVMA_Send(byte[] txData)
    {
        Logger.LogEx($"---- {DateTime.Now:yyyy/MM/dd HH:mm:ss} ------------------");
        StringBuilder sb = new StringBuilder();
        sb.Append($"[->S:{txData[3]:X2}] [");
        for (int i = 4; i < txData.Length; i++)
        {
            sb.Append($"{txData[i]:X2}.");
        }
        sb.Append("]");
        Logger.LogEx(sb.ToString());
        Logger.LogEx("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        
        byte[] rxData = new byte[JVMAConstants.PACKET_BUFFER_SIZE];
        int result = s_comm!.MvtTxRx(txData, rxData);

        if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK1)
            return 0; // I

        // G[ƍđWbN
        if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_NACK)
        {
            result = s_comm!.MvtTxRx(txData, rxData);
             if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK1)
                return 0;
        }
        else
        {
            byte terminal = (byte)(txData[0] & JVMAConstants.MVT_TERM_BITS);
            byte[] resendTx = {(byte)(JVMAConstants.CMD_RESEND | terminal), (byte)~(JVMAConstants.CMD_RESEND | terminal)};
            result = s_comm!.MvtTxRx(resendTx, rxData);
            if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK1)
                return 0;
        }

        return -1; // ُI
    }

    private static int MVT_Ctrl_Send(byte ctrl_flg)
    {
        byte[] txData = new byte[5];
        int i = 0;
        txData[i++] = (byte)(JVMAConstants.CMD_SEND | JVMAConstants.JVMA_MVT_TERM);
        txData[i++] = (byte)~txData[0];
        txData[i++] = 2;       // BC
        txData[i++] = 0x10;    // DC
        txData[i++] = ctrl_flg;

        return JVMA_Send(txData);
    }
    
    private static int MVT_Kobetu_Send()
    {
        byte[] txData = new byte[28]; // 3(wb_) + 25(f[^)
        DateTime now = DateTime.Now;

        int i = 0;
        txData[i++] = (byte)(JVMAConstants.CMD_SEND | JVMAConstants.JVMA_MVT_TERM);
        txData[i++] = (byte)~txData[0];
        txData[i++] = 25;      // BC
        txData[i++] = 0x15;    // DC

        txData[i++] = 0; // [JR[h
        txData[i++] = 0x07; // ̋@
        txData[i++] = 0; // \tgo[W
        txData[i++] = Utils.HEX2BCD((byte)now.Second);
        txData[i++] = Utils.HEX2BCD((byte)now.Minute);
        txData[i++] = Utils.HEX2BCD((byte)now.Hour);
        txData[i++] = Utils.HEX2BCD((byte)now.DayOfWeek);
        txData[i++] = Utils.HEX2BCD((byte)now.Day);
        txData[i++] = Utils.HEX2BCD((byte)now.Month);
        txData[i++] = Utils.HEX2BCD((byte)(now.Year % 100));
        txData[i++] = Utils.HEX2BCD((byte)(now.Year / 100));
        txData[i++] = 30; // Z^C}l
        i += 10; // }VR[hAP[VR[h (0Ŗ߂)
        
        // INIt@Cǂݍ݂̑
        byte byTime = 30; // NotEndRetryTime
        txData[i++] = byTime; // gC^C}
        txData[i++] = 1; // uh
        
        return JVMA_Send(txData);
    }

    private static int MVT_BrandSet_Send()
    {
        byte[,] MVT_BrandSetInfo = new byte[8, 13];

        for (int i = 0; i < MVT_BrandCount; i++)
        {
            for(int j = 0; j < 13; j++)
            {
                 MVT_BrandSetInfo[i, j] = MVT_BrandStatus[i, j];
            }
            MVT_BrandSetInfo[i, 2] = 0;
        }

        byte[] txData = new byte[4 + 105]; // 4(wb_) + 105(f[^)
        int idx = 0;
        txData[idx++] = (byte)(JVMAConstants.CMD_SEND | JVMAConstants.JVMA_MVT_TERM);
        txData[idx++] = (byte)~txData[0];
        txData[idx++] = 106; // BC
        txData[idx++] = 0x14; // DC
        txData[idx++] = (byte)MVT_BrandCount;

        Buffer.BlockCopy(MVT_BrandStatus, 0, txData, idx, 104);
        
        return JVMA_Send(txData);
    }

    private static void MTV_Brand_Awase()
    {
        int phase = 0;
        bool loop = true;
        // INIt@Cǂݍ݂̑
        int byTime = 5; // BrandAwaseLimitTime ()
        Stopwatch timer = Stopwatch.StartNew();
        long limit = byTime * 60 * 1000;

        do
        {
            if (timer.ElapsedMilliseconds > limit)
            {
                break;
            }

            switch (phase)
            {
                case 0: phase = 10; break;
                case 10:
                    if ((MVT_RcvFlag & JVMAConstants.MVT_RCV_1DH) != 0)
                    {
                        MVT_RcvFlag &= unchecked((ushort)~JVMAConstants.MVT_RCV_1DH);
                        phase = 20;
                    }
                    break;
                case 20:
                    Thread.Sleep(70);
                    MVT_BrandSet_Send();
                    phase = 30;
                    break;
                case 30:
                     if ((MVT_RcvFlag & JVMAConstants.MVT_RCV_1DH) != 0)
                    {
                        MVT_RcvFlag &= unchecked((ushort)~JVMAConstants.MVT_RCV_1DH);
                        phase = 40;
                    }
                    break;
                case 40:
                    Thread.Sleep(70);
                    MVT_BrandSet_Send();
                    phase = 50;
                    break;
                case 50:
                    Thread.Sleep(70);
                    MVT_Ctrl_Send(1);
                    loop = false;
                    break;
            }
            Thread.Sleep(70);
            MVT_ChangedRequest();
        } while (!f_SigTerm && loop);
    }

    private static int CheckCBDX()
    {
        if (JVMA_Standby(0xF0) != 0)
        {
            Console.WriteLine("CBDX-D ܂B");
            return -1;
        }

        if (CBDX_AllRequest(0xF0) != 0)
        {
            Console.WriteLine("CBDX-D ƒʐMł܂B");
            return -1;
        }

        Console.WriteLine("CBDX-D Ɛڑ܂B");
        return 0;
    }

    private static int CBDX_AllRequest(byte terminal)
    {
        byte[] txData = { (byte)(JVMAConstants.CMD_AREQ | terminal), (byte)~(JVMAConstants.CMD_AREQ | terminal) };
        byte[] rxData = new byte[JVMAConstants.PACKET_BUFFER_SIZE];
        int result = s_comm!.MvtTxRx(txData, rxData);

        if (result > 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK1)
        {
            // f[^M (KvȂ)
        }
        else if (result == 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK4)
        {
            return -2; // X^oCKv
        }
        else
        {
            txData = new byte[] { (byte)(JVMAConstants.CMD_REREQ | terminal), (byte)~(JVMAConstants.CMD_REREQ | terminal) };
            result = s_comm!.MvtTxRx(txData, rxData);
            if (result > 1 && rxData[0] == JVMAConstants.MVT_ACK_ACK3)
            {
                 // f[^M (KvȂ)
            }
            else
            {
                 return -1;
            }
        }
        return 0;
    }

    private static int CBDX_Ctrl_Send()
    {
        byte[] txData = new byte[5];
        int i = 0;
        txData[i++] = 0xF3;
        txData[i++] = (byte)~txData[0];
        txData[i++] = 2;    // BC
        txData[i++] = 0x70; // DC
        txData[i++] = 0x80;
        return JVMA_Send(txData); 
    }

    private static void MVTAnalyze(byte ack_type, byte length, byte[] src, int srcOffset)
    {
        Logger.LogEx($"---- {DateTime.Now:yyyy/MM/dd HH:mm:ss} ------------------");
        
        int offset = (ack_type == 0x22) ? 0 : 1;
        int bc = 0;

        while (offset == 0 || (bc + src[bc + srcOffset] + 1) <= length)
        {
            byte dataId = src[bc + srcOffset + offset];
            int dataLen = (offset == 0) ? length - 1 : src[bc + srcOffset] - 1;
            int dataOffset = bc + srcOffset + offset + 1;
            
            StringBuilder logData = new StringBuilder($"[<-R:{dataId:X2}] [");
            for (int i = 0; i < dataLen; i++)
            {
                logData.Append($"{src[dataOffset + i]:X2}.");
            }
            logData.Append("]");
            Logger.LogEx(logData.ToString());

            switch (dataId)
            {
                case 0x18: // \˗f[^
                    g_lBalance = Utils.BCDToLong(src, dataOffset, 3);
                    MVT_RcvFlag |= JVMAConstants.MVT_RCV_18H;
                    break;
                case 0x19: // MVTό
                    Array.Copy(src, dataOffset, MVT_Result, 0, Math.Min(dataLen, MVT_Result.Length));
                    MVT_RcvFlag |= JVMAConstants.MVT_RCV_19H;
                    break;
                case 0x1D: // uhԃf[^
                    MVT_BrandCount = src[dataOffset];
                    Buffer.BlockCopy(src, dataOffset + 1, MVT_BrandStatus, 0, Math.Min(dataLen -1, MVT_BrandStatus.Length));
                    MVT_RcvFlag |= JVMAConstants.MVT_RCV_1DH;
                    break;
                // ̃f[^ID̃P[Xlɒǉ
            }
            
            if (offset == 0) break;
            bc += src[bc + srcOffset] + 1;
            if (bc + offset + 1 >= length) break;
        }
        Logger.LogEx("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }
}

// Copyright 2023 OCT Co.,Ltd. All Rights Reserved.
